<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}
// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSocialMedia extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS , $_LANG;

		parent::DoEvents();		
	}

	function __init() {
		global $_CONF;

		if ($this->__inited) {
			return "";
		}

		$this->__inited = true;
		
		$path = $this->tpl_path;

		$templates = array(
			"sharethis"								=> "sharethis.htm",
			"addthis"								=> "addthis.htm",

			"profiles"								=> "profiles.htm",

			"menu"									=> "menu.htm",
			"share"									=> "share.htm",
		);

		foreach ($templates as $key => $val) {
			$this->private->templates[$key] = new CTemplateDynamic(
				$path . $val
			);
		}

		$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule("socialmedia");

		$this->items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:socialmedia_services']} as p
				
			WHERE
				service_status = 1 
			ORDER BY
				service_order
			"
		);

		$lang_data = $this->db->QFetchRowArray("
			SELECT * FROM 
				{$this->tables['plugin:socialmedia_services_lang']} 
			WHERE
				lang_id in  ( %d , %d ) 
			" , 
			array(
				$this->tpl_module["lang_id"],
				$this->plugins["languages"]->languages[$this->plugins["languages"]->default_lang]["lang_id"]
			)
		);

		if (is_array($this->items)) {
			foreach ($this->items as $key => $val) {
				$items[$val["service_id"]] = $val;
			}
			
			$this->items = $items;

			if (is_array($lang_data)) {
				foreach ($lang_data as $key => $val) {

					if (!$this->items[$val["service_id"]]["lang_id"] || ($this->items[$val["service_id"]]["lang_id"] != $this->tpl_module["lang_id"])) {					

						$this->items[$val["service_id"]] = array_merge(
							$this->items[$val["service_id"]],
							$val
						);
					}
				
				}				
			}


			$this->SchemaOrg();
			
		}


		
	
	} 




	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Share($link , $title = "" , $image = "" , $description = "") {
		global $base;

		$this->__init();

		$this->cnt ++;

		//strip all tags in title
		$title = strip_tags($title);
		//strip all shortcodes
		$title =  preg_replace("/\[[^)]+\]/","",$title);

		//debug($title);

		switch ($this->tpl_module["settings"]["set_service"]) {
			default:
				return $this->private->templates["share"]->blockReplace(
					"Main",
					array(
						"id"			=> $this->cnt,
						"title"			=> $title,
						"link"			=> $link,

						"set_theme"		=> $this->tpl_module["settings"]["set_theme"],
						"set_size"		=> $this->tpl_module["settings"]["set_size"],
						"set_label"		=> $this->tpl_module["settings"]["set_label"] ? "true" : "false",
						"set_count"		=> $this->tpl_module["settings"]["set_count"] ? $this->tpl_module["settings"]["set_count"] : "true",
						"set_services"	=> str_replace("," , '","' , $this->tpl_module["settings"]["set_services"]),

					)
				);

			break;

			case "sharethis":
				return $this->ShareThisButtons($link , $title, $image , $description);
			break;

			case "addthis":
				return $this->AddThisButtons($link , $title, $image , $description);
			break;
		}
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ShowProfiles() {
		$this->__init();

		global $base;

		if (!is_array($this->items)) {
			return "";
		}
		
		foreach ($this->items as $key => $val) {
			if ($val["service_profile"]) {
				$profiles[] = $val;
			}			
		}
		

		if (!is_array($profiles)) {
			return "";
		}

		return $base->html->Table(
			$this->private->templates["profiles"],
			"" , 
			$profiles
		);
		
	}
	


	function onGlobalHooksExecute($module) {

		global $_TSM;

		$this->__init();

		//get all profiles

		$this->ShareThis();
		$this->AddThis();

	
		$_TSM["MODULE:SOCIAL_PROFILES"] = $this->ShowProfiles();
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetMenuButton($module) {
		global $base;

		$this->__init();


		if (is_array($this->items)) {

			foreach ($this->items as $key => $val) {
				if ($val["service_profile"]) {
					$items[] = $val;
				}
				
			}
			
			if (is_array($items)) {

				if ($module["settings"]["set_menu_style"]) {
					return array(
						"html"	=> $base->html->Table(
							$this->_t("menu"),
							"Links",
							$items , 
							$module["settings"]
						)
					); 
				} else {				
					return array(
						"html"	=> $this->_t("menu")->blockReplace(
							"Menu",
							array(
								"items"	=> $base->html->Table(
									$this->_t("menu"),
									"",
									$items,
									$this->plugins["backgrounds"]->GetBg($module["settings"]["set_menu_bg"])
								),
							),
							$module["settings"]
						)
					);
				}
			}						
		}
		
	}	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddThis() {

		if ($this->tpl_module["settings"]["set_service"] != "addthis") {
			return "";
		}

		$this->initAddThis();
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function initAddThis() {

		if (!$this->initedAddThis) {

			$this->plugins["seo"]->AppendToBody(
				$this->_t("addthis")->blockReplace(
					"Body",
					array(
						"id"	=> $this->vars->data["set_addthis_publisher"],
					)
				)
			);

			$this->initedAddThis = true;
		}		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function initShareThis() {

		if (!$this->initedShareThis) {

			$this->plugins["seo"]->AppendToHead(
				$this->_t("sharethis")->blockReplace(
					"Head",
					array(
						"publisher"	=> $this->vars->data["set_sharethis_publisher"],
					)
				)
			);

			$this->initedShareThis = true;
		}
		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddThisButtons($link , $title, $image , $description) {
		global $base;

		$title = strip_tags($title);


		if (!$this->vars->data["set_sharethis_publisher"]) {
			return "";
		}

		$this->__init();

		switch ($this->vars->data["set_sharethis_display"]) {
			default:
			case "2":
				return $this->_t("addthis")->blockReplace(
					"Inline",
					array(
						"link"			=> $link,
						"title"			=> $title, 
						"image"			=> $image , 
						"description"	=> $description
					)
				);		
			break;
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ShareThis() {

		if ($this->tpl_module["settings"]["set_service"] != "sharethis") {
			return "";
		}

		$this->initShareThis();
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ShareThisButtons($link , $title, $image , $description) {
		global $base;

		$title = strip_tags($title);

		if (!$this->vars->data["set_sharethis_publisher"]) {
			return "";
		}

		$this->__init();

		switch ($this->vars->data["set_sharethis_display"]) {
			case "2":
				return $this->_t("sharethis")->blockReplace(
					"Inline",
					array(
						"link"			=> $link,
						"title"			=> $title, 
						"image"			=> $image , 
						"description"	=> $description
					)
				);		
			break;

			case "3":
				$services = explode("," , $this->vars->data["set_sharethis_services"]);
				$elements = explode("," , $this->vars->data["set_sharethis_show"]);
				
				
				if (is_array($services)) {
					foreach ($services as $key => $val) {

						if ($this->_t("sharethis")->blockExists($val)) {

							$_services[]["content"] = $this->_t("sharethis")->blockReplace(
								$val , 
								array(
									"link"			=> $link,
									"title"			=> $title, 
									"image"			=> $image , 
									"description"	=> $description,
									"username"		=> $this->vars->data["set_sharethis_twitter"],
									"_count"		=> in_array("count" , $elements) ? $this->_t("sharethis")->blockReplace("_count") : "",
								)
							);
						}						
					}
					
					if (is_array($_services)) {
						return $base->html->table(
							$this->_t("sharethis"),
							"CustomButtons",
							$_services,
							array(
								"text"		=> in_array("text" , $elements) ? "true" : "",
								"icon"		=> in_array("icon" , $elements) ? "true" : "",
								"btn_size"	=> $this->vars->data["set_sharethis_btn_size"],
								"btn_style"	=> str_replace("," , " " , $this->vars->data["set_sharethis_btn_style"]),
							)
						);
					}					
				}

			break;

			case "4":
				return $this->_t("sharethis")->blockReplace(
					"InlineReactions",
					array(
						"link"			=> $link,
						"title"			=> $title, 
						"image"			=> $image , 
						"description"	=> $description
					)
				);		
			break;

		}
		
		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SchemaOrg() {

		$links = array();

		foreach ($this->items as $key => $val) {
			if ($val["service_profile"]) {
				$links[] = $val["service_profile"];
			}			
		}
		
		$this->plugins["seo"]->SocialSchema($links);
	}
	
}


/*
share this custom buttons template generator some icons have to be manualy changed( ex: googleplus -> google-plus etc )

$tmp = explode("\n" , "blogger
delicious
digg
email
facebook
flipboard
googleplus
linkedin
livejournal
mailru
meneame
odnoklassniki
pinterest
print
reddit
sharethis
sms
stumbleupon
tumblr
twitter
vk
weibo
whatsapp
xing");

foreach ($tmp as $k => $v) {
	$v = trim($v);
	$u = ucwords($v);
	echo "<!--S:{$v}-->	
<div 
	data-network=\"{$v}\" 
	data-url=\"{LINK}\" 
	data-title=\"{TITLE}\"
	data-image=\"{IMAGE}\"
	data-description=\"{DESCRIPTION}\"	
	class=\"btn {BG:SCHEME} {BTN_SIZE} {BTN_STYLE} st-custom-button st-custom-button-{$v}\">
	<span class=\"icon icomoon icon-{$v}\"></span>
	<span class=\"text\">{$u}</span>
	{_COUNT}
</div>
<!--E:{$v}-->\n\n";
}

die("X");
*/
